<?php
echo "<h1>Installation Debug</h1>";

echo "<h3>1. Check installed.lock file:</h3>";
if (file_exists('api/config/installed.lock')) {
    echo "✅ installed.lock EXISTS<br>";
    echo "Content: " . file_get_contents('api/config/installed.lock') . "<br>";
} else {
    echo "❌ installed.lock NOT FOUND<br>";
}

echo "<h3>2. Check env.php file:</h3>";
if (file_exists('api/config/env.php')) {
    echo "✅ env.php EXISTS<br>";
} else {
    echo "❌ env.php NOT FOUND<br>";
}

echo "<h3>3. Check directories permissions:</h3>";
if (is_writable('api/config/')) {
    echo "✅ api/config/ is WRITABLE<br>";
} else {
    echo "❌ api/config/ is NOT WRITABLE<br>";
}

echo "<h3>4. Try creating lock file manually:</h3>";
try {
    $result = file_put_contents('api/config/installed.lock', date('Y-m-d H:i:s'));
    if ($result) {
        echo "✅ Successfully created lock file<br>";
        echo "<a href='index.php'>Go to main website</a>";
    } else {
        echo "❌ Failed to create lock file<br>";
    }
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
}

echo "<h3>5. Database connection test:</h3>";
if (file_exists('api/config/env.php')) {
    require_once 'api/config/env.php';
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
        $pdo = new PDO($dsn, DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        echo "✅ Database connection successful<br>";
        echo "Host: " . DB_HOST . "<br>";
        echo "Database: " . DB_NAME . "<br>";
        echo "User: " . DB_USER . "<br>";
    } catch (Exception $e) {
        echo "❌ Database error: " . $e->getMessage() . "<br>";
    }
} else {
    echo "⚠️ env.php not found. Please run install.php first.<br>";
}
?>

<hr>
<h3>Quick Actions:</h3>
<a href="install.php">Run Installation Wizard</a> | 
<a href="api/setup.php">Check API Status</a> |
<a href="index.html">Visit Website</a>
