<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://infinitymedical.co');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Access-Control-Allow-Credentials: true');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    exit(0);
}

require_once 'config/database.php';
require_once 'config/cors.php';

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Get the request URI and method
$request_uri = $_SERVER['REQUEST_URI'];
$request_method = $_SERVER['REQUEST_METHOD'];

// Parse the route
$path = parse_url($request_uri, PHP_URL_PATH);
$path_segments = explode('/', trim($path, '/'));

// Remove 'api' from path if it's there
if (isset($path_segments[0]) && $path_segments[0] === 'api') {
    array_shift($path_segments);
}

try {
    // Route handling
    switch ($request_method) {
        case 'GET':
            handleGetRequests($path_segments);
            break;
        case 'POST':
            handlePostRequests($path_segments);
            break;
        case 'PUT':
            handlePutRequests($path_segments);
            break;
        case 'DELETE':
            handleDeleteRequests($path_segments);
            break;
        default:
            http_response_code(405);
            echo json_encode(['error' => 'Method not allowed']);
            break;
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Server error: ' . $e->getMessage()]);
}

function handleGetRequests($path_segments) {
    switch ($path_segments[0] ?? '') {
        case '':
        case 'get':
            require_once 'controllers/ProductController.php';
            $controller = new ProductController();
            $controller->getAllParts();
            break;
        case 'parts':
            require_once 'controllers/ProductController.php';
            $controller = new ProductController();
            if (isset($_GET['modality'])) {
                $controller->getPartsByModality($_GET['modality']);
            } else {
                $controller->getAllParts();
            }
            break;
        case 'dashboard':
            require_once 'controllers/AdminController.php';
            $controller = new AdminController();
            $controller->dashboard();
            break;
        default:
            http_response_code(404);
            echo json_encode(['error' => 'Route not found']);
            break;
    }
}

function handlePostRequests($path_segments) {
    switch ($path_segments[0] ?? '') {
        case 'form':
            require_once 'controllers/FormController.php';
            $controller = new FormController();
            $controller->handleDetailedForm();
            break;
        case 'forms':
            require_once 'controllers/FormController.php';
            $controller = new FormController();
            $controller->handleSimpleForm();
            break;
        case 'rental':
            require_once 'controllers/RentalController.php';
            $controller = new RentalController();
            $controller->handleRentalForm();
            break;
        case 'add':
            require_once 'controllers/ProductController.php';
            $controller = new ProductController();
            $controller->addPart();
            break;
        case 'login':
            require_once 'controllers/AdminController.php';
            $controller = new AdminController();
            $controller->login();
            break;
        default:
            http_response_code(404);
            echo json_encode(['error' => 'Route not found']);
            break;
    }
}

function handlePutRequests($path_segments) {
    if (isset($path_segments[0]) && is_numeric($path_segments[0])) {
        require_once 'controllers/ProductController.php';
        $controller = new ProductController();
        $controller->updatePart($path_segments[0]);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Route not found']);
    }
}

function handleDeleteRequests($path_segments) {
    if (isset($path_segments[0]) && is_numeric($path_segments[0])) {
        require_once 'controllers/ProductController.php';
        $controller = new ProductController();
        $controller->deletePart($path_segments[0]);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Route not found']);
    }
}
?>
