<?php
/**
 * Infinity Medical - Auto Installer Entry Point
 * Checks if system is installed, redirects accordingly
 */

// Check if system is installed
if (file_exists('api/config/installed.lock')) {
    // System is installed, serve the main website
    if (file_exists('index.html')) {
        // Read and serve the main HTML file
        header('Content-Type: text/html; charset=UTF-8');
        readfile('index.html');
        exit();
    } else {
        // Fallback if index.html missing
        echo '<!DOCTYPE html>
<html>
<head>
    <title>Infinity Medical</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
    <h1>Welcome to Infinity Medical</h1>
    <p>Your website is installed but index.html is missing.</p>
    <p><a href="api/setup.php">Check System Status</a></p>
</body>
</html>';
        exit();
    }
} else {
    // System not installed, redirect to installer
    header('Location: install/');
    exit();
}
?>
