<?php
/**
 * PHP Backend Setup Script
 * Run this script once to set up the database and test the installation
 */

require_once 'config/database.php';
require_once 'config/env.php';

echo "<h1>PHP Backend Setup</h1>";

try {
    // Test database connection
    echo "<h2>Testing Database Connection...</h2>";
    $db = Database::getInstance();
    echo "<p style='color: green;'>✅ Database connection successful!</p>";
    
    // Test file upload directory
    echo "<h2>Testing File Upload Directory...</h2>";
    $uploadDir = __DIR__ . '/uploads/';
    if (is_dir($uploadDir) && is_writable($uploadDir)) {
        echo "<p style='color: green;'>✅ Upload directory exists and is writable!</p>";
    } else {
        echo "<p style='color: red;'>❌ Upload directory issue. Creating directory...</p>";
        if (mkdir($uploadDir, 0755, true)) {
            echo "<p style='color: green;'>✅ Upload directory created successfully!</p>";
        } else {
            echo "<p style='color: red;'>❌ Failed to create upload directory!</p>";
        }
    }
    
    // Test email configuration
    echo "<h2>Email Configuration</h2>";
    echo "<p>SMTP Host: " . SMTP_HOST . "</p>";
    echo "<p>SMTP Port: " . SMTP_PORT . "</p>";
    echo "<p>From Email: " . SMTP_FROM_EMAIL . "</p>";
    echo "<p style='color: orange;'>⚠️ Please update email credentials in api/config/env.php</p>";
    
    // Test admin credentials
    echo "<h2>Admin Configuration</h2>";
    echo "<p>Admin Username: " . ADMIN_USERNAME . "</p>";
    echo "<p>Admin Password: " . str_repeat('*', strlen(ADMIN_PASSWORD)) . "</p>";
    echo "<p style='color: orange;'>⚠️ Please change default admin credentials in api/config/env.php</p>";
    
    echo "<h2>API Endpoints</h2>";
    echo "<ul>";
    echo "<li>POST /api/form - Detailed contact form</li>";
    echo "<li>POST /api/forms - Simple contact form</li>";
    echo "<li>POST /api/rental - Rental service form</li>";
    echo "<li>POST /api/add - Add new part (with image upload)</li>";
    echo "<li>GET /api/ - Get all parts</li>";
    echo "<li>GET /api/parts?modality=X - Get parts by modality</li>";
    echo "<li>PUT /api/{id} - Update part</li>";
    echo "<li>DELETE /api/{id} - Delete part</li>";
    echo "<li>POST /api/login - Admin login</li>";
    echo "<li>GET /api/dashboard - Admin dashboard (requires JWT)</li>";
    echo "</ul>";
    
    echo "<h2>System Status</h2>";
    echo "<ul>";
    echo "<li>✅ Database connection: Working</li>";
    echo "<li>✅ File upload directory: " . (is_dir($uploadDir) && is_writable($uploadDir) ? "Ready" : "Needs attention") . "</li>";
    echo "<li>✅ Configuration file: Loaded</li>";
    echo "</ul>";
    
    echo "<h2>Configuration</h2>";
    echo "<p>All configuration is managed through <strong>api/config/env.php</strong></p>";
    echo "<p>To update settings, edit the env.php file or run install.php again.</p>";
    
    echo "<p style='color: green; font-weight: bold;'>🎉 PHP Backend setup completed successfully!</p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Setup failed: " . $e->getMessage() . "</p>";
}
?>
