<?php
// Load environment configuration
require_once __DIR__ . '/env.php';

class Database {
    private static $instance = null;
    private $connection;
    
    private function __construct() {
        try {
            // Use configuration from env.php
            $host = defined('DB_HOST') ? DB_HOST : 'localhost';
            $database = defined('DB_NAME') ? DB_NAME : 'infinity_medical';
            $username = defined('DB_USER') ? DB_USER : 'root';
            $password = defined('DB_PASS') ? DB_PASS : '';
            
            $dsn = "mysql:host={$host};dbname={$database};charset=utf8mb4";
            $this->connection = new PDO($dsn, $username, $password);
            $this->connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->connection->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
            $this->createTables();
        } catch (PDOException $e) {
            throw new Exception('Database connection failed: ' . $e->getMessage());
        }
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new Database();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        return $this->connection;
    }
    
    private function createTables() {
        $queries = [
            // Services table (equivalent to form model)
            "CREATE TABLE IF NOT EXISTS services (
                id INT AUTO_INCREMENT PRIMARY KEY,
                first_name VARCHAR(255) NOT NULL,
                last_name VARCHAR(255) NOT NULL,
                company_name VARCHAR(255),
                email VARCHAR(255),
                phone_number VARCHAR(20),
                part VARCHAR(255) NOT NULL,
                modality VARCHAR(255) NOT NULL,
                manufacturer VARCHAR(255) NOT NULL,
                part_description TEXT,
                submitted_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )",
            
            // Ser table (simple contact form)
            "CREATE TABLE IF NOT EXISTS ser (
                id INT AUTO_INCREMENT PRIMARY KEY,
                first_name VARCHAR(255) NOT NULL,
                last_name VARCHAR(255) NOT NULL,
                company_name VARCHAR(255),
                email VARCHAR(255),
                phone_number VARCHAR(20),
                part_description TEXT NOT NULL,
                submitted_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )",
            
            // Rental table
            "CREATE TABLE IF NOT EXISTS rental (
                id INT AUTO_INCREMENT PRIMARY KEY,
                first_name VARCHAR(255) NOT NULL,
                last_name VARCHAR(255) NOT NULL,
                company_name VARCHAR(255),
                email VARCHAR(255),
                phone_number VARCHAR(20),
                rental_service VARCHAR(255) NOT NULL,
                part_description TEXT,
                submitted_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )",
            
            // Parts table
            "CREATE TABLE IF NOT EXISTS parts (
                id INT AUTO_INCREMENT PRIMARY KEY,
                part_number VARCHAR(255) NOT NULL,
                manufacturer VARCHAR(255) NOT NULL,
                modality VARCHAR(255) NOT NULL,
                product VARCHAR(255) NOT NULL,
                modal VARCHAR(255),
                image VARCHAR(500) NOT NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
            )"
        ];
        
        foreach ($queries as $query) {
            try {
                $this->connection->exec($query);
            } catch (PDOException $e) {
                error_log("Error creating table: " . $e->getMessage());
            }
        }
    }
}
?>
